<?php

namespace App\Exports;

use App\Enums\ContainerEntryStatus;
use App\Models\ContainerEntry;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithTitle;

class ContainerEntriesUnprocessedExport implements FromCollection, WithHeadings, WithMapping, WithTitle
{
    public function collection(): Collection
    {
        return ContainerEntry::with(['usuarioAsignado', 'usuariosAsignados', 'theoreticalArticles'])
            ->where('estado', ContainerEntryStatus::EN_PROCESO->value)
            ->orderBy('created_at', 'desc')
            ->get();
    }

    public function headings(): array
    {
        return [
            'ID',
            'Nº Camión',
            'Marca',
            'Tipo Producto',
            'Estado',
            'Usuarios Asignados',
            'Unidades Totales',
            'Fecha Creación',
            'Notas',
        ];
    }

    public function map($entry): array
    {
        $users = [];
        if ($entry->usuarioAsignado) {
            $users[] = $entry->usuarioAsignado->name . ' (principal)';
        }
        foreach ($entry->usuariosAsignados as $u) {
            $users[] = $u->name;
        }

        // Calcular unidades totales sumando cantidad_unidades de todos los artículos teóricos
        $totalUnidades = $entry->theoreticalArticles->sum('cantidad_unidades');

        return [
            $entry->id,
            $entry->n_camion,
            $entry->marca,
            $entry->tipo_producto,
            method_exists($entry->estado, 'label') ? $entry->estado->label() : (string) $entry->estado,
            implode(', ', array_unique($users)),
            $totalUnidades,
            optional($entry->created_at)->format('Y-m-d H:i:s'),
            $entry->notes,
        ];
    }

    public function title(): string
    {
        return 'Contenedores En Proceso';
    }
}


