<?php

namespace App\Enums;

enum ContainerEntryStatus: string
{
    case EN_PROCESO = 'En Proceso';
    case FINALIZADO = 'Finalizado';

    /**
     * Get all status values as array.
     */
    public static function values(): array
    {
        return array_column(self::cases(), 'value');
    }

    /**
     * Get all status labels.
     */
    public static function labels(): array
    {
        return [
            self::EN_PROCESO->value => 'En Proceso',
            self::FINALIZADO->value => 'Finalizado',
        ];
    }

    /**
     * Get label for the current status.
     */
    public function label(): string
    {
        return match($this) {
            self::EN_PROCESO => 'En Proceso',
            self::FINALIZADO => 'Finalizado',
        };
    }

    /**
     * Check if status is "En Proceso".
     */
    public function isEnProceso(): bool
    {
        return $this === self::EN_PROCESO;
    }

    /**
     * Check if status is "Finalizado".
     */
    public function isFinalizado(): bool
    {
        return $this === self::FINALIZADO;
    }
}

