# Resumen de Funcionalidades Implementadas

## 📋 Índice
1. [Gestión de Entradas de Contenedores](#gestión-de-entradas-de-contenedores)
2. [Portal de Clientes](#portal-de-clientes)
3. [Asignación Múltiple de Usuarios](#asignación-múltiple-de-usuarios)
4. [Exportaciones y Reportes](#exportaciones-y-reportes)
5. [Paginación en Tablas](#paginación-en-tablas)
6. [Impresión de Etiquetas](#impresión-de-etiquetas)

---

## 🚛 Gestión de Entradas de Contenedores

### **Ubicación**: Menú → "Entradas Contenedores"

### Funcionalidades:

#### 1. **Crear Nueva Entrada de Contenedor**
- **Ruta**: `Entradas Contenedores` → Botón "Nueva Entrada"
- **Descripción**: Crea un nuevo registro de entrada de camión/contenedor
- **Campos requeridos**:
  - Nº Camión (único)
  - Marca, Tipo Producto (opcionales)
  - Usuario Asignado (opcional)

#### 2. **Cargar Artículos Teóricos (Excel)**
- **Ruta**: `Entradas Contenedores` → Ver detalle de contenedor → Sección "Artículos Teóricos"
- **Formato del Excel**:
  - **Columnas obligatorias**: `mocaco`, `cantidad_unidades`
  - **Columnas opcionales**: `campana`, `seccion`, `familia_articulo_description`, `cadena`, `mercado_origen_articulo`, `precio_pvp_maximo_temporada`, `partida_arancelaria`, `composition`, `peso_unitario`, `grupo_arancelario`, `season_int`, `categoria_seleccionada`, `famillie_usuario`, `detail_usuario`, `notes`
- **Reglas de importación**:
  - No se permiten duplicados dentro del mismo archivo (mismo `mocaco` + `campana`)
  - No se permiten duplicados ya existentes en BD para el mismo contenedor
  - Se omiten filas con `mocaco` vacío

#### 3. **Descargar Plantilla Excel**
- **Ruta**: `Entradas Contenedores` → Botón "Plantilla Teóricos (XLSX)"
- **Descripción**: Descarga un archivo Excel de ejemplo con todas las columnas necesarias
- **Uso**: Úsalo como base para crear tu archivo de carga

#### 4. **Asignar Múltiples Usuarios**
- **Ruta**: `Entradas Contenedores` → Botón con ícono de usuarios (👥) en la fila del contenedor
- **Descripción**: Permite asignar uno o varios usuarios a un contenedor
- **Modal**: Se abre un modal con lista de usuarios, selecciona múltiples con Ctrl/Cmd

#### 5. **Ver Progreso de Escaneo**
- **Ruta**: `Entradas Contenedores` → Ver detalle de contenedor
- **Descripción**: Muestra porcentaje de avance comparando unidades teóricas vs escaneadas
- **Fórmula**: `(Unidades Escaneadas / Unidades Teóricas) × 100`

#### 6. **Finalizar Contenedor**
- **Ruta**: `Entradas Contenedores` → Ver detalle de contenedor → Botón "Finalizar"
- **Proceso**:
  1. El sistema genera un reporte de discrepancias automáticamente
  2. Si hay discrepancias, se muestra el reporte detallado
  3. Aparece botón "Finalizar de Todas Formas" para forzar la finalización
  4. El reporte muestra:
     - Total teórico vs escaneado
     - Discrepancias por MOCACO (faltantes, excesos, no esperados)
     - Tabla detallada con hasta 20 discrepancias
     - Enlace para descargar reporte completo en JSON

#### 7. **Exportar Contenedores No Procesados**
- **Ruta**: `Entradas Contenedores` → Botón "Exportar No Procesados (XLSX)"
- **Descripción**: Exporta todos los contenedores con estado "En Proceso" a Excel
- **Uso**: Para saber qué contenedores aún no se han trabajado

#### 8. **Filtros Disponibles**
- Por Estado (En Proceso / Finalizado)
- Por Nº Camión
- Por Usuario Asignado (solo admin)

---

## 👥 Portal de Clientes

### **Ubicación**: Menú → "Portal de Clientes" (visible solo para usuarios con `client_id` asignado)

### Requisitos Previos:
1. **Crear Usuario Cliente**:
   - **Ruta**: `Usuarios` → Crear Usuario
   - **Pasos**:
     - Completar datos básicos (nombre, email, contraseña)
     - En campo "Cliente (Portal de Clientes)": Seleccionar el cliente
     - En "Roles": Seleccionar rol `client` (opcional pero recomendado)
     - Guardar

2. **Asignar Factura a Pedido** (Admin):
   - **Ruta**: `Pedidos` → Editar Pedido
   - **Campo**: "URL PDF Factura" (solo visible para admin)
   - **Ingresar**: URL completa del PDF de la factura (ej: `https://ejemplo.com/factura.pdf`)

### Funcionalidades del Portal:

#### 1. **Ver Mis Reservas**
- **Ruta**: `Portal de Clientes` → Lista de reservas
- **Descripción**: Muestra todos los pedidos/reservas del cliente
- **Estados mostrados**: Reservado, Confirmado, Despachado
- **Información mostrada**:
  - ID Pedido
  - Estado
  - Fecha Pedido
  - Fecha Despacho
  - Total Artículos
  - Notas

#### 2. **Ver Detalle de Pedido**
- **Ruta**: `Portal de Clientes` → Click en "Ver" de un pedido
- **Descripción**: Muestra información completa del pedido con Packing List agrupado
- **Packing List Agrupado**:
  - Agrupa por MOCACO (EAN) y FAMILIA
  - Muestra unidades totales por grupo
  - Muestra cajas únicas por grupo
  - Resumen: Total artículos, Total grupos, Total cajas

#### 3. **Descargar Factura PDF**
- **Ruta**: `Portal de Clientes` → Ver detalle de pedido → Botón "Descargar Factura PDF"
- **Descripción**: Descarga el PDF de la factura asociada al pedido
- **Nota**: Solo aparece si el admin ha subido la URL de la factura

#### 4. **Filtros Disponibles**
- Por Estado (Reservado / Confirmado / Despachado)
- Búsqueda por ID Pedido o notas

---

## 👥 Asignación Múltiple de Usuarios

### **Ubicación**: `Entradas Contenedores` → Botón con ícono de usuarios (👥)

### Funcionalidad:
- Permite asignar múltiples usuarios a un mismo contenedor
- Los usuarios asignados pueden ver el contenedor en su lista
- Compatible con el usuario principal (campo `usuario_asignado_id`)

### Cómo usar:
1. En la lista de contenedores, click en el botón con ícono de usuarios
2. Se abre un modal con lista de usuarios
3. Selecciona múltiples usuarios (Ctrl/Cmd + click)
4. Click en "Asignar"
5. Los usuarios aparecerán en la columna "Usuarios Asignados"

### Nota:
- Los operarios (no admin) solo ven contenedores asignados a ellos o disponibles (sin asignar)

---

## 📊 Exportaciones y Reportes

### 1. **Exportar Inventario Agrupado (XLSX)**
- **Ruta**: `Inventario` → Botón "Exportar Agrupado (XLSX)"
- **Descripción**: Exporta inventario agrupado por campos del artículo
- **Agrupación**: Por MOCACO, Sección, Familia, Cadena, etc.
- **Columna especial**: `UNIDADES` (suma de registros por grupo)
- **Formato**: XLSX (Excel)

### 2. **Exportar Contenedores No Procesados**
- **Ruta**: `Entradas Contenedores` → Botón "Exportar No Procesados (XLSX)"
- **Descripción**: Exporta contenedores con estado "En Proceso"
- **Uso**: Para saber qué contenedores aún no se han trabajado

### 3. **Reporte de Productividad**
- **Ruta**: Menú → "Reportes de Productividad"
- **Descripción**: Muestra productividad por operario
- **Agrupación**: Por operario y fecha
- **Métricas**:
  - Unidades escaneadas
  - Número de cajas únicas procesadas
  - Promedio por caja
- **Exportación**: Botón "Exportar CSV"

### 4. **Reporte de Discrepancias**
- **Ruta**: `Entradas Contenedores` → Ver detalle → Sección "Reporte de Discrepancias"
- **Descripción**: Compara inventario teórico vs escaneado
- **Información**:
  - Total teórico vs escaneado
  - Discrepancias por MOCACO
  - Tipo: Faltante, Exceso, No Esperado
- **Exportación**: Botón "Ver Reporte Completo (JSON)"

---

## 📄 Paginación en Tablas

### **Tablas con Paginación Completa**:
1. **Inventario** (`Inventario`)
2. **Artículos** (`Artículos`)
3. **Clientes** (`Clientes`)
4. **Entradas de Contenedores** (`Entradas Contenedores`)
5. **Reportes de Productividad** (`Reportes de Productividad`)

### **Características**:
- Selector "Líneas por página": 10, 25, 50, 100, 250
- Información de página: "Página X de Y (Z registros)"
- Navegación: Botones "Anterior" y "Siguiente"
- Números de página clickeables
- Filtros preservados al cambiar de página

---

## 🖨️ Impresión de Etiquetas

### **Ubicación**: `Escáner` → Botones de impresión

### Requisitos:
1. **Instalar QZ Tray**:
   - Descargar desde: https://qz.io/download
   - Instalar y ejecutar (debe estar corriendo en segundo plano)

2. **Driver de Impresora Térmica**:
   - Instalar driver ZDesigner para impresoras Zebra
   - Configurar tamaño de papel/etiqueta

3. **Navegador**:
   - Usar HTTPS o `http://localhost`
   - Permitir conexión con QZ Tray cuando se solicite

### Funcionalidades:

#### 1. **Imprimir Etiqueta de Caja Actual**
- **Ruta**: `Escáner` → Botón "Imprimir Etiqueta"
- **Descripción**: Genera e imprime etiqueta de la caja actual
- **Contenido**: Agrupado por SECCIÓN y FAMILIA con unidades totales
- **Formato**: ZPL (para impresoras térmicas)

#### 2. **Reimprimir Etiqueta**
- **Ruta**: `Escáner` → Botón "Reimprimir"
- **Descripción**: Busca una caja por número y permite reimprimir su etiqueta
- **Proceso**:
  1. Click en "Reimprimir"
  2. Se abre modal para buscar caja
  3. Ingresar número de caja
  4. Click en "Buscar"
  5. Si se encuentra, aparece botón "Imprimir Etiqueta"

---

## 🔐 Seguridad y Permisos

### **Roles y Accesos**:

1. **Admin**:
   - Acceso completo a todas las funcionalidades
   - Puede asignar usuarios a contenedores
   - Puede subir URLs de facturas
   - Puede finalizar contenedores incluso con discrepancias

2. **Operario** (Usuario sin rol admin):
   - Solo ve contenedores asignados a él o disponibles
   - Puede escanear artículos
   - Puede imprimir etiquetas
   - No puede finalizar contenedores

3. **Cliente** (Usuario con `client_id`):
   - Acceso solo al Portal de Clientes
   - Solo ve sus propios pedidos
   - Puede descargar facturas de sus pedidos

---

## 📝 Notas Importantes

### **Sobre la Carga de Artículos Teóricos**:
- El sistema NO reemplaza artículos existentes automáticamente
- Si necesitas reemplazar, debes eliminar manualmente los artículos teóricos actuales
- Los duplicados se omiten automáticamente (según regla MOCACO + CAMPAÑA)

### **Sobre el Finalizado de Contenedores**:
- Si hay discrepancias, el reporte siempre se muestra
- Puedes finalizar de todas formas usando el botón "Finalizar de Todas Formas"
- El reporte de discrepancias queda guardado incluso después de finalizar

### **Sobre el Portal de Clientes**:
- Los usuarios deben tener `client_id` asignado para acceder
- Solo ven pedidos asociados a su `client_id`
- El acceso está protegido por middleware de seguridad

---

## 🎯 Rutas Principales

| Funcionalidad | Ruta en Menú | Ruta URL |
|--------------|--------------|----------|
| Entradas Contenedores | Entradas Contenedores | `/container-entries` |
| Portal de Clientes | Portal de Clientes | `/portal` |
| Inventario | Inventario | `/inventory` |
| Artículos | Artículos | `/articles` |
| Clientes | Clientes | `/clients` |
| Pedidos | Pedidos | `/orders` |
| Escáner | Escáner | `/scanner` |
| Reportes Productividad | Reportes de Productividad | `/reports/productivity` |
| Usuarios | Usuarios | `/users` |

---

## ✅ Checklist de Uso Rápido

### Para crear un contenedor y cargar artículos:
- [ ] Ir a "Entradas Contenedores"
- [ ] Click en "Nueva Entrada"
- [ ] Completar datos del contenedor
- [ ] Ir a detalle del contenedor
- [ ] Descargar plantilla Excel (opcional)
- [ ] Llenar Excel con artículos teóricos
- [ ] Subir Excel en "Artículos Teóricos"
- [ ] Verificar progreso de escaneo

### Para crear un usuario cliente:
- [ ] Ir a "Usuarios"
- [ ] Click en "Crear Usuario"
- [ ] Asignar cliente en campo "Cliente (Portal de Clientes)"
- [ ] Asignar rol "client" (opcional)
- [ ] Guardar

### Para finalizar un contenedor:
- [ ] Ir a detalle del contenedor
- [ ] Verificar que los artículos estén escaneados
- [ ] Click en "Finalizar"
- [ ] Revisar reporte de discrepancias
- [ ] Si hay discrepancias, decidir:
  - Corregir discrepancias y volver a intentar, O
  - Click en "Finalizar de Todas Formas"

---

**Última actualización**: Noviembre 2025

